module RPG
  
  # Classe originale du module RPG
  class Map
    def initialize(width, height)
      @tileset_id = 1
      @width = width
      @height = height
      @autoplay_bgm = false
      @bgm = RPG::AudioFile.new
      @autoplay_bgs = false
      @bgs = RPG::AudioFile.new("", 80)
      @encounter_list = []
      @encounter_step = 30
      @data = Table.new(width, height, 3)
      @events = {}
      @dm = {}
    end
    attr_accessor :tileset_id
    attr_accessor :width
    attr_accessor :height
    attr_accessor :autoplay_bgm
    attr_accessor :bgm
    attr_accessor :autoplay_bgs
    attr_accessor :bgs
    attr_accessor :encounter_list
    attr_accessor :encounter_step
    attr_accessor :data
    attr_accessor :events


    #################################################
    # Ajouts
    #################################################

    attr_accessor :name

  

    # Rcupre la partie RMXP originale de l'objet
    def to_rmxp
      return self
    end


    @@reg_numero = /^Map(\d+)\.rxdata$/

    # Transforme une map RMXP en map DMK
    #
    # numero : le numro de la map RMXP (contenu dans le nom de fichier)
    def to_dmk
      my = My_RPG::My_Map.new(@width, @height)

      my.tileset_id = @tileset_id

      my.autoplay_bgm = @autoplay_bgm
      my.bgm = @bgm
      my.autoplay_bgs = @autoplay_bgs
      my.bgs = @bgs
      my.encounter_list = @encounter_list
      my.encounter_step = @encounter_step
      my.data = @data
      my.name = @name
      my.events = {}

      # On rcupre le numro
      numero = @@reg_numero.obtain(@name).to_i
      my.numero = numero


      liste = self.events.to_a

      # Affectation de leur numro aux events
      for arr in liste
        # On rcupre le numro
        numero_event = arr[0]
      
        # On transforme l'event en version DMK
        event_dmk = arr[1].to_dmk(numero_event)

        event_dmk.map = my

        my.events.update({numero_event => event_dmk})

      end

      my.dm = self.dm

      return my
    end


    # Compare deux maps RMXP
    def comparer(map)
      
      #return false if super(map) == false
      
      if @events.size != map.events.size
        raise(DMKW_DMK_Diff.new("map.events.size"))
      end
      if @tileset_id != map.tileset_id
        raise(DMKW_DMK_Diff.new("map.tileset_id"))
      end
      if @width != map.width
        raise(DMKW_DMK_Diff.new("map.width"))
      end
      if @height != map.height
        raise(DMKW_DMK_Diff.new("map.height"))
      end
      if @autoplay_bgm != map.autoplay_bgm
        raise(DMKW_DMK_Diff.new("map.autoplay_bgm"))
      end
      if @bgm != map.bgm
        raise(DMKW_DMK_Diff.new("map.bgm"))
      end
      if @autoplay_bgs != map.autoplay_bgs
        raise(DMKW_DMK_Diff.new("map.autoplay_bgs"))
      end
      if @bgs != map.bgs
        raise(DMKW_DMK_Diff.new("map.bgs"))
      end
      if @encounter_list != map.encounter_list
        raise(DMKW_DMK_Diff.new("map.encounter_list"))
      end
      if @encounter_step != map.encounter_step
        raise(DMKW_DMK_Diff.new("map.encounter_step"))
      end
      if @data != map.data
        raise(DMKW_DMK_Diff.new("map.data"))
      end


      if @events.size != map.events.size
        raise(DMKW_DMK_Diff.new("map.events : size"))
      end
      list = @events.keys
      for key in list
        @events[key].comparer(map.events[key])
      end


      #for event in @events
      #  return false if event[1] != map.events[event[0]]
      #end
    
      return true
    end

    def dm
      return @dm
    end

    def dm=(value)
      @dm = value
    end

  end


end